package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Remo_FL_door extends FrontDoor
{
	public Remo_FL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Remo front left door";

		value = 250;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );
		
		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.remo:0x000000C3r, "L mirror", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000D9r, "FL window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000C3r, "L mirror", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000D9r, "FL window", actcolor, optical, power );
		}
	}
}
